/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BStationDiscoveryJob;
import com.tridium.provisioningNiagara.bootstrap.BAbstractDiscoveryStep;
import com.tridium.provisioningNiagara.bootstrap.LearnStationDeviceInfo;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="useHostname", type="boolean", defaultValue="false")
public class BNiagaraNetworkDiscoveryStep
extends BAbstractDiscoveryStep {
    @Generated
    public static final Property useHostname = BNiagaraNetworkDiscoveryStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkDiscoveryStep.class);
    private static final int DISCOVERY_JOB_FAILSAFE_TIMEOUT = 10000;
    private static final Logger logger = Logger.getLogger(BNiagaraNetworkDiscoveryStep.class.getName());

    @Generated
    public boolean getUseHostname() {
        return this.getBoolean(useHostname);
    }

    @Generated
    public void setUseHostname(boolean v) {
        this.setBoolean(useHostname, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp op) {
        BNiagaraNetwork network = (BNiagaraNetwork)nw;
        logger.fine("Running Station Discovery Job");
        BStationDiscoveryJob job = new BStationDiscoveryJob(network);
        JobCompletionHandler handler = new JobCompletionHandler();
        handler.subscribe((BComponent)job);
        logger.fine(job.getJobState().toString());
        job.submit((Context)op);
        while (job.getJobState().isRunning()) {
            logger.fine(job.getJobState().toString());
            try {
                BNiagaraNetworkDiscoveryStep bNiagaraNetworkDiscoveryStep = this;
                synchronized (bNiagaraNetworkDiscoveryStep) {
                    ((Object)((Object)this)).wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        List<Object> learnedStations = Arrays.asList(job.getChildren(BLearnStation.class));
        learnedStations.forEach(s -> s.invariant(this.getUseHostname()));
        this.updateConnectionInfo(details, devices, learnedStations, learnStation -> new LearnStationDeviceInfo((BLearnStation)learnStation, this.getUseHostname()));
    }

    private class JobCompletionHandler
    extends Subscriber {
        private JobCompletionHandler() {
            this.setMask(BComponentEventMask.make((int[])new int[]{0}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(BComponentEvent event) {
            if (event.getSourceComponent() instanceof BStationDiscoveryJob && event.getSlot().equals((Object)BStationDiscoveryJob.jobState) && ((BJobState)event.getValue()).isComplete()) {
                logger.fine(() -> String.format("Discovery job complete", new Object[0]));
                try {
                    BNiagaraNetworkDiscoveryStep bNiagaraNetworkDiscoveryStep = BNiagaraNetworkDiscoveryStep.this;
                    synchronized (bNiagaraNetworkDiscoveryStep) {
                        ((Object)((Object)BNiagaraNetworkDiscoveryStep.this)).notifyAll();
                    }
                }
                finally {
                    this.unsubscribe(event.getSourceComponent());
                }
            }
        }
    }
}

