/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.provisioningNiagara.bootstrap.BAbstractDiscoveryStep;
import com.tridium.provisioningNiagara.bootstrap.DhcpdLeaseSettingsDeviceInfo;
import java.security.AccessController;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDhcpDiscoveryStep
extends BAbstractDiscoveryStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BDhcpDiscoveryStep.class);
    private static final Logger LOGGER = Logger.getLogger(BDhcpDiscoveryStep.class.getName());

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doRun(BBatchJobService batchJobService, BNetworkStepDetails networkStepDetails, BDeviceNetwork deviceNetwork, BDevice[] devices, DeviceNetworkJobOp deviceNetworkJobOp) throws Exception {
        if (networkStepDetails == null || networkStepDetails.log() == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Provided NetworkStepDetails is null or NetworkStepDetails log is null");
            LOGGER.log(Level.SEVERE, this.lexValue("unexpectedError", new Object[0]), illegalArgumentException);
            throw illegalArgumentException;
        }
        BDaemonSession session = this.getLocalSession();
        if (session == null) {
            this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)networkStepDetails).vaFailed(arg_0, arg_1), LOGGER::severe, "DhcpDiscoveryStep.unableToConnectToLocalPlatform", new String[0]);
            networkStepDetails.complete(BJobState.failed);
            return;
        }
        if (!DhcpdUtil.supportsDhcpd((BDaemonSession)session)) {
            this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)networkStepDetails).vaFailed(arg_0, arg_1), LOGGER::severe, "DhcpDiscoveryStep.dhcpdUnsupported", new String[0]);
            networkStepDetails.complete(BJobState.failed);
            return;
        }
        try {
            List leases = DhcpdUtil.getDhcpdLeases((BDaemonSession)session, (boolean)true, (boolean)true);
            this.updateConnectionInfo(networkStepDetails, devices, leases, DhcpdLeaseSettingsDeviceInfo::new);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, this.lexValue("unexpectedError", new Object[0]), exception);
            throw exception;
        }
    }

    public BDaemonSession getLocalSession() {
        return AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
    }
}

