/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.backup;

import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import java.security.AccessController;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public final class BBackupStepDetailsRpc
extends BSingleton {
    @Generated
    public static final BBackupStepDetailsRpc INSTANCE = new BBackupStepDetailsRpc();
    @Generated
    public static final Type TYPE = Sys.loadType(BBackupStepDetailsRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BNiagaraStation getStation(String stationName) throws Exception {
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        return (BNiagaraStation)nn.getStation(stationName);
    }

    public static boolean validateDistPassphraseToPlatform(BNiagaraStation station, FilePath distFilePath) throws Exception {
        boolean result = false;
        if (distFilePath != null && station != null) {
            BPlatformConnection platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            BDaemonSession daemonSession = platformConn.getDaemonSession();
            BIFile backupDistFile = BFileSystem.INSTANCE.findFile(distFilePath);
            BDistribution dist = new BDistribution(backupDistFile);
            PBEEncodingInfo distEncodingInfo = dist.getManifest().getPBEEncodingInfo();
            result = distEncodingInfo != null && daemonSession.validateSystemPassPhrase((PBEValidator)distEncodingInfo);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean validateDistPassphraseToPlatform(String stationName, String distributionFilePath, Context cx) throws Exception {
        BDistributionFile distFile = (BDistributionFile)BOrd.make((String)distributionFilePath).get((BObject)BLocalHost.INSTANCE, cx);
        BBackupStepDetailsRpc.checkPermissions(distFile, cx);
        BNiagaraStation station = BBackupStepDetailsRpc.getStation(stationName);
        return BBackupStepDetailsRpc.validateDistPassphraseToPlatform(station, distFile.getFilePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validatePassphraseToDist(FilePath distributionFilePath, BPassword passphrase) throws Exception {
        boolean result = false;
        if (distributionFilePath == null) return result;
        if (passphrase == null) return result;
        BIFile backupDistFile = BFileSystem.INSTANCE.findFile(distributionFilePath);
        BDistribution dist = new BDistribution(backupDistFile);
        PBEEncodingInfo distEncodingInfo = dist.getManifest().getPBEEncodingInfo();
        if (distEncodingInfo == null) return false;
        if (!distEncodingInfo.test(AccessController.doPrivileged(() -> ((BPassword)passphrase).getSecretChars()))) return false;
        return true;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean validatePassphraseToDist(String distributionFilePath, String passphraseString, Context cx) throws Exception {
        BDistributionFile distributionFile = (BDistributionFile)BOrd.make((String)distributionFilePath).get(null, cx);
        BBackupStepDetailsRpc.checkPermissions(distributionFile, cx);
        BPassword passphrase = BPassword.make((String)passphraseString);
        return BBackupStepDetailsRpc.validatePassphraseToDist(distributionFile.getFilePath(), passphrase);
    }

    public static void checkPermissions(BDistributionFile distributionFile, Context cx) {
        if (!distributionFile.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to look up job details.");
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static BOrd startRestoreJob(String batchJobStepLogFileOrd, String backupStepDetailsJson, String passwordString, Context cx) throws Exception {
        BBackupStepDetails backupStepDetails = (BBackupStepDetails)BsonDecoderPlugin.unmarshal((String)backupStepDetailsJson, (Context)cx);
        BBatchJobStepLogFile batchJobStepLogFile = !batchJobStepLogFileOrd.isEmpty() ? (BBatchJobStepLogFile)BOrd.make((String)batchJobStepLogFileOrd).get() : (BBatchJobStepLogFile)backupStepDetails.getLogFile();
        BPassword password = !passwordString.isEmpty() ? BPassword.make((String)passwordString) : null;
        return backupStepDetails.startRestoreJob((BObject)batchJobStepLogFile, password, cx);
    }
}

