/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.backup;

import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.software.BInstallByOrdStep;
import com.tridium.provisioningNiagara.software.BInstallDistWithPassPhraseStep;
import java.io.IOException;
import java.security.AccessController;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="backupFileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1)
public class BBackupStepDetails
extends BDeviceStepDetails {
    @Generated
    public static final Property backupFileOrd = BBackupStepDetails.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBackupStepDetails.class);
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public BOrd getBackupFileOrd() {
        return (BOrd)this.get(backupFileOrd);
    }

    @Generated
    public void setBackupFileOrd(BOrd v) {
        this.set(backupFileOrd, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBackupStepDetails() {
    }

    public BBackupStepDetails(BNiagaraStation station, BDeviceJobStep jobStep) {
        super((BDevice)station, jobStep);
        try {
            BBackupStationExt stationExt = (BBackupStationExt)station.getMixIn(BBackupStationExt.TYPE);
            this.setBackupFileOrd(stationExt.newBackupFileOrd());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BOrd startRestoreJob(BObject base, BPassword distPassphrase, Context cx) throws Exception {
        BBatchJobService batch = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(base, cx);
        batch.lease();
        BNiagaraNetworkJob job = new BNiagaraNetworkJob(this.getDeviceId().toString());
        if (Objects.nonNull(distPassphrase) && !distPassphrase.isDefault()) {
            BInstallDistWithPassPhraseStep installStep = new BInstallDistWithPassPhraseStep(this.getBackupFileOrd());
            installStep.setDistPassphrase(distPassphrase);
            job.addStep(installStep);
        } else {
            BInstallByOrdStep installStep = new BInstallByOrdStep(this.getBackupFileOrd());
            job.addStep(installStep);
        }
        return batch.submitJob((BBatchJob)job, null).getNavOrd();
    }

    public void doDispose() throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        if (!this.getBackupFileOrd().isNull()) {
            AccessController.doPrivileged(() -> {
                try {
                    BIFile file = (BIFile)this.getBackupFileOrd().get();
                    Logger.getLogger("provisioningNiagara").info("Deleting backup file " + file.getFilePath().getBody());
                    file.delete();
                }
                catch (UnresolvedException ue) {
                    Logger.getLogger("provisioningNiagara").severe("Backup file not found: " + this.getBackupFileOrd());
                }
                catch (IOException ioe) {
                    Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "Error deleting backup file " + this.getBackupFileOrd(), ioe);
                }
                return null;
            });
            this.setBackupFileOrd(BOrd.NULL);
        }
        super.doDispose();
    }

    public String getDisposalAction() {
        return String.format("%s\n", LEX.getText("BackupStepDetailsView.disposalAction", new Object[]{this.getBackupFileOrd()}));
    }
}

