/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.authn.AuthenticationClient;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.bootstrap.BDeviceBootstrapExt;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.provisioningNiagara.software.BInstallableSummary;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.station.BStationPollScheduler;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.template.BTemplateStationExt;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.fox.BFoxProxySession;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.license.Feature;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="software", type="BSoftwareContainer", defaultValue="new BSoftwareContainer()", flags=3), @NiagaraProperty(name="licenses", type="BSupervisorLicenses", defaultValue="new BSupervisorLicenses()", flags=1), @NiagaraProperty(name="pollScheduler", type="BStationPollScheduler", defaultValue="new BStationPollScheduler()"), @NiagaraProperty(name="deviceRebootTimeout", type="int", defaultValue="600", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="stationShutdownTimeout", type="int", defaultValue="300", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="connectTimeout", type="int", defaultValue="60000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="socketTimeout", type="int", defaultValue="5000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")})})
public class BProvisioningNiagaraNetworkExt
extends BAbstractService
implements BFoxService.FoxServerConnectionListener {
    @Generated
    public static final Property software = BProvisioningNiagaraNetworkExt.newProperty((int)3, (BValue)new BSoftwareContainer(), null);
    @Generated
    public static final Property licenses = BProvisioningNiagaraNetworkExt.newProperty((int)1, (BValue)new BSupervisorLicenses(), null);
    @Generated
    public static final Property pollScheduler = BProvisioningNiagaraNetworkExt.newProperty((int)0, (BValue)new BStationPollScheduler(), null);
    @Generated
    public static final Property deviceRebootTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property stationShutdownTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)300, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property connectTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)60000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property socketTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)5000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Type TYPE = Sys.loadType(BProvisioningNiagaraNetworkExt.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private ProvisioningRegistry installableRegistry = null;
    private boolean serviceStarted = false;
    private CompletableFuture<Void> whenServiceStarted = new CompletableFuture();
    private static final Logger logger = Logger.getLogger("provisioningNiagara");
    private CertificateChainValidator certValidator;
    private static final String SECURITY_HIGH = "module://icons/x16/security-high.png";
    private static final String SECURITY_MEDIUM = "module://icons/x16/security-medium.png";
    private static final String SECURITY_LOW = "module://icons/x16/security-low.png";

    @Generated
    public BSoftwareContainer getSoftware() {
        return (BSoftwareContainer)this.get(software);
    }

    @Generated
    public void setSoftware(BSoftwareContainer v) {
        this.set(software, (BValue)v, null);
    }

    @Generated
    public BSupervisorLicenses getLicenses() {
        return (BSupervisorLicenses)this.get(licenses);
    }

    @Generated
    public void setLicenses(BSupervisorLicenses v) {
        this.set(licenses, (BValue)v, null);
    }

    @Generated
    public BStationPollScheduler getPollScheduler() {
        return (BStationPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BStationPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public int getDeviceRebootTimeout() {
        return this.getInt(deviceRebootTimeout);
    }

    @Generated
    public void setDeviceRebootTimeout(int v) {
        this.setInt(deviceRebootTimeout, v, null);
    }

    @Generated
    public int getStationShutdownTimeout() {
        return this.getInt(stationShutdownTimeout);
    }

    @Generated
    public void setStationShutdownTimeout(int v) {
        this.setInt(stationShutdownTimeout, v, null);
    }

    @Generated
    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    @Generated
    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    @Generated
    public int getSocketTimeout() {
        return this.getInt(socketTimeout);
    }

    @Generated
    public void setSocketTimeout(int v) {
        this.setInt(socketTimeout, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraNetwork getNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public void serverConnectionCreated(BFoxServerConnection connection, FoxSession session, FoxMessage remoteHello) {
        BFoxChannelRegistry channelRegistry = connection.getChannels();
        if (channelRegistry.getProperty("niagaraProv") == null) {
            logger.fine("BProvisioningNiagaraNetworkExt server connection created, adding niagaraProv channel to registry");
            channelRegistry.add("niagaraProv", (BValue)new BNiagaraProvisioningChannel());
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void started() {
        logger.fine("Enabling provisioning mix-ins");
        long startTimeMS = Clock.ticks();
        BComponentSpace space = this.getComponentSpace();
        space.enableMixIn(BPlatformConnection.TYPE);
        space.enableMixIn(BStationProxy.TYPE);
        space.enableMixIn(BSoftwareStationExt.TYPE);
        space.enableMixIn(BBackupStationExt.TYPE);
        space.enableMixIn(BLicenseStationExt.TYPE);
        space.enableMixIn(BTemplateStationExt.TYPE);
        space.enableMixIn(BDeviceBootstrapExt.TYPE);
        logger.fine(() -> String.format("Provisioning mix-ins enabled in %dms", Clock.ticks() - startTimeMS));
    }

    public void serviceStarted() {
        logger.fine("Initializing provisioning service");
        long startTimeMS = Clock.ticks();
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        try {
            Sys.getService((Type)Sys.getType((String)"provisioning:ProvisioningService"));
            this.configFail("Cannot have ProvisioningService and ProvisioningNiagaraNetworkExt on the same station");
            this.whenServiceStarted().complete(null);
            return;
        }
        catch (ModuleNotFoundException | ServiceNotFoundException | TypeNotFoundException throwable) {
            if (this.getProperty("backupSchedule") != null) {
                Logger.getLogger("provisioningNiagara").warning("ProvisioningNiagaraNetworkExt backup schedule is deprecated, and will not trigger backups");
            }
            try {
                Sys.getService((Type)Sys.getType((String)"batchJob:BatchJobService"));
            }
            catch (ServiceNotFoundException snfe) {
                this.configFail("ProvisioningNiagaraNetworkExt requires that a BatchJobService be installed");
                this.whenServiceStarted().completeExceptionally(snfe);
                return;
            }
            BBatchJobService batch = (BBatchJobService)Sys.getService((Type)Sys.getType((String)"batchJob:BatchJobService"));
            ((CompletableFuture)batch.whenServiceStarted().exceptionally(e -> {
                this.whenServiceStarted().completeExceptionally((Throwable)e);
                this.configFail("ProvisioningNiagaraNetworkExt startup FAILED: BatchJobService not started successfully");
                Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "BatchJobService not started successfully", (Throwable)e);
                return null;
            })).thenApplyAsync(ignored -> {
                try {
                    BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
                    if (foxService == null) {
                        logger.warning("Fox Service was not found. Provisioning channel server is unavailable");
                    } else {
                        foxService.registerServerConnectionListener((BFoxService.FoxServerConnectionListener)this);
                    }
                    this.updateStatus();
                    this.getSoftware().serviceStarted();
                    this.whenServiceStarted().complete(null);
                    Logger.getLogger("provisioningNiagara").log(Level.INFO, "Provisioning Network Extension Startup Complete");
                }
                catch (Throwable e) {
                    this.configFail("ProvisioningNiagaraNetworkExt startup FAILED");
                    Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "ProvisioningNiagaraNetworkExt startup FAILED", e);
                    this.whenServiceStarted().completeExceptionally(e);
                }
                return null;
            });
            logger.fine(() -> String.format("Provisioning service initialized in %dms", Clock.ticks() - startTimeMS));
            return;
        }
    }

    public void serviceStopped() {
        this.serviceStarted = false;
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        if (foxService != null) {
            foxService.unregisterServerConnectionListener((BFoxService.FoxServerConnectionListener)this);
        }
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "provisioning");
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.box)})
    public JSONObject getSoftwareValidationStatus(List<String> encodedSpecs, Context cx) throws Exception {
        CertificateChainValidator certValidator = this.getCertValidator();
        List specs = encodedSpecs.stream().map(encodedSpec -> this.unmarshal((String)encodedSpec, cx)).collect(Collectors.toList());
        ArrayList<BModuleInstallable> failures = new ArrayList<BModuleInstallable>();
        HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
        for (BInstallableSpec spec : specs) {
            BInstallable installable2 = LocalInstallableRegistry.getInstance().findInstallable(spec.asDependency(), null);
            if (!(installable2 instanceof BModuleInstallable)) continue;
            BModulePart part = ((BModuleInstallable)installable2).getModulePart();
            List statuses = part.getSignatureStatus(certValidator);
            if (statuses.contains(ModuleSignatureStatusEnum.INVALID_SIGNATURE)) {
                failures.add((BModuleInstallable)installable2);
                continue;
            }
            if (statuses.contains(ModuleSignatureStatusEnum.OK)) continue;
            for (ModuleSignatureStatusEnum status : statuses) {
                warnings.computeIfAbsent(status, k -> new ArrayList()).add(installable2.toString());
            }
        }
        JSONObject statusInfo = new JSONObject();
        if (failures.size() > 0) {
            statusInfo.put("failures", failures.stream().map(installable -> installable.toString()));
        }
        if (warnings.size() > 0) {
            statusInfo.put("warnings", warnings);
        }
        return statusInfo;
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.box)})
    public JSONArray getInstallableSpecsIcons(String complexNavOrd, List<String> specNames, Context cx) throws Exception {
        CertificateChainValidator certValidator = this.getCertValidator();
        BInstallableSummary installableSummary = (BInstallableSummary)BOrd.make((String)complexNavOrd).get(null, cx);
        if (!installableSummary.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException("Insufficient privileges to access the installable.");
        }
        JSONArray specIcons = new JSONArray();
        for (String specName : specNames) {
            String specIcon = null;
            BInstallableSpec spec = (BInstallableSpec)installableSummary.get(specName);
            try {
                BInstallable installable = LocalInstallableRegistry.getInstance().findInstallable(spec.asDependency(), null);
                BModulePart part = ((BModuleInstallable)installable).getModulePart();
                List statuses = part.getSignatureStatus(certValidator);
                specIcon = statuses.contains(ModuleSignatureStatusEnum.OK) ? SECURITY_HIGH : (statuses.contains(ModuleSignatureStatusEnum.INVALID_SIGNATURE) ? SECURITY_LOW : SECURITY_MEDIUM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (specIcon == null) {
                specIcon = spec.getIcon().encodeToString();
            }
            specIcons.put((Object)new JSONObject().put(specName, (Object)specIcon));
        }
        return specIcons;
    }

    public boolean completesStarted() {
        return true;
    }

    public CompletableFuture<Void> whenServiceStarted() {
        return this.whenServiceStarted;
    }

    public void updateStatus() {
        int oldStatus = this.getStatus().getBits();
        super.updateStatus();
        int newStatus = this.getStatus().getBits();
        if (oldStatus != newStatus) {
            this.updateStatusForAllProvisioningExtensions();
        }
    }

    private void updateStatusForAllProvisioningExtensions() {
        BNiagaraNetwork nn = null;
        try {
            nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (nn == null) {
            return;
        }
        for (BDevice device : nn.getDevices()) {
            for (BDeviceExt ext : device.getDeviceExts()) {
                if (!(ext instanceof BPlatformConnection) && !(ext instanceof BProvisioningStationExt)) continue;
                try {
                    ext.updateStatus();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BFoxProxySession getFoxProxySession(BNiagaraStation station) {
        BFoxClientConnection clientConnection = station.getClientConnection();
        BFoxSession session = (BFoxSession)BFoxProxySession.make((BHost)station.getRemoteHost(), (int)clientConnection.getPort(), (FoxConnectionTypeEnum)BFoxClientWebsocketBehavior.getFoxConnectionType((BFoxClientWebsocketBehavior)clientConnection.getFoxOverWebsocket(), (boolean)clientConnection.getUseFoxs()), (int)clientConnection.getFoxOverWebsocketPort(), (BIUserCredentials)clientConnection.getCredentials());
        station.configureFoxClientConnection(session.getConnection());
        session.getConnection().setAuthenticationClient((AuthenticationClient)session.getConnection());
        return session;
    }

    public ProvisioningRegistry getInstallableRegistry() {
        if (this.installableRegistry == null) {
            BFoxSession session = (BFoxSession)this.getSession();
            BNiagaraProvisioningChannel channel = (BNiagaraProvisioningChannel)session.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
            this.installableRegistry = new ProvisioningRegistry(channel);
        }
        return this.installableRegistry;
    }

    public BIcon getIcon() {
        return icon;
    }

    private BInstallableSpec unmarshal(String encodedSpec, Context cx) {
        try {
            return (BInstallableSpec)BsonDecoderPlugin.unmarshal((String)encodedSpec, (Context)cx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CertificateChainValidator getCertValidator() {
        if (this.certValidator == null) {
            this.certValidator = new CertificateChainValidator();
            CoreCryptoManager mgr = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
            ICoreTrustStore trustStore = mgr.getSystemTrustStore();
            this.certValidator.addTrustAnchors(trustStore);
        }
        return this.certValidator;
    }
}

