/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.uxBuilder.ui;

import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NProperty;
import com.tridium.ui.util.ValidationUtil;
import com.tridium.uxBuilder.servlet.PxUxAgentFilter;
import com.tridium.uxBuilder.ui.BUxMedia;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bajaux.BIJavaScriptWidget;
import javax.baja.gx.BBrush;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BBinding;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.shape.BShape;
import javax.baja.util.BConverter;
import javax.baja.util.LexiconModule;
import javax.baja.web.js.BIJavaScript;

public final class UxValidationUtil {
    private static final LexiconModule LEX = LexiconModule.make(UxValidationUtil.class);
    private static final LexiconModule BAJA_UI_LEX = LexiconModule.make((String)"bajaui");

    private UxValidationUtil() {
    }

    public static String validateWidget(BWidget widget, Context cx) {
        BIJavaScriptWidget jsWidget;
        String customWarning;
        BIJavaScript js;
        AgentList list;
        String uxMediaWarnings;
        String webWarnings;
        StringBuilder b = new StringBuilder();
        TypeInfo typeInfo = widget.getType().getTypeInfo();
        if (!BUxMedia.INSTANCE.isWidgetSupported(typeInfo)) {
            return BAJA_UI_LEX.getText("validateMedia.unsupportedType", cx, new Object[]{typeInfo});
        }
        if (widget.getType().is(BNullWidget.TYPE)) {
            return null;
        }
        String subclassWarnings = UxValidationUtil.getUxMediaSubclassWarnings((BComplex)widget, cx);
        if (subclassWarnings != null) {
            b.append(subclassWarnings);
        }
        if ((webWarnings = ValidationUtil.getWebWarnings((BWidget)widget, (Context)cx)) != null) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(webWarnings);
        }
        if ((uxMediaWarnings = UxValidationUtil.getUxMediaWarnings(widget, cx)) != null) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(uxMediaWarnings);
        }
        if ((list = PxUxAgentFilter.getAgentList(typeInfo).filter((AgentFilter)new PxUxAgentFilter(typeInfo))).size() > 0 && (js = (BIJavaScript)list.getDefault().getInstance()) instanceof BIJavaScriptWidget && (customWarning = (jsWidget = (BIJavaScriptWidget)js).validateWidget((BComponent)widget, cx)) != null) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(customWarning);
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }

    public static String getUxMediaWarnings(BWidget widget, Context cx) {
        StringBuilder b = new StringBuilder();
        boolean imageBrushForegroundWarning = false;
        SlotCursor c = widget.getProperties();
        while (c.next()) {
            BBrush brush;
            BValue value = c.get();
            String slotName = ((Property)c.slot()).getName();
            if (!(value instanceof BBrush) || !((brush = (BBrush)value).getPaint() instanceof BBrush.Image) || !"foreground".equals(slotName)) continue;
            imageBrushForegroundWarning = true;
        }
        if (imageBrushForegroundWarning) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(LEX.getText("validateMedia.imageBrushForegroundWarning", cx));
        }
        if (widget instanceof BShape) {
            BBrush.Paint strokePaint;
            BShape shape = (BShape)widget;
            BBrush.Paint fillPaint = shape.getFill().getPaint();
            if (fillPaint instanceof BBrush.Image && ((BBrush.Image)fillPaint).getTile() != 1) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(LEX.getText("validateMedia.onlyTiledImagesForShapes", cx));
            }
            if ((strokePaint = shape.getStroke().getPaint()) instanceof BBrush.Image && ((BBrush.Image)strokePaint).getTile() != 1) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(LEX.getText("validateMedia.onlyTiledImagesForShapes", cx));
            }
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }

    public static String validateBinding(BBinding binding, Context cx) {
        StringBuilder b = new StringBuilder();
        String subClassWarnings = UxValidationUtil.getUxMediaSubclassWarnings((BComplex)binding, cx);
        if (subClassWarnings != null) {
            b.append(subClassWarnings);
        }
        for (BConverter converter : (BConverter[])binding.getChildren(BConverter.class)) {
            TypeInfo converterInfo = converter.getType().getTypeInfo();
            if (!UxValidationUtil.isTypeSupported(converterInfo)) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(BAJA_UI_LEX.getText("validateMedia.unsupportedType", cx, new Object[]{converterInfo}));
                continue;
            }
            String converterSubClassWarnings = UxValidationUtil.getUxMediaSubclassWarnings((BComplex)converter, cx);
            if (converterSubClassWarnings == null) continue;
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(converterSubClassWarnings);
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }

    public static boolean isTypeSupported(TypeInfo type) {
        AgentList list = PxUxAgentFilter.getAgentList(type).filter((AgentFilter)new PxUxAgentFilter(type));
        return list.size() > 0;
    }

    public static String getUxMediaSubclassWarnings(BComplex c, Context cx) {
        TypeInfo typeInfo = c.getType().getTypeInfo();
        AgentList specificList = Sys.getRegistry().getSpecificAgents(typeInfo).filter((AgentFilter)new PxUxAgentFilter(typeInfo));
        if (specificList.size() > 0) {
            return null;
        }
        TypeInfo supportedTypeInfo = UxValidationUtil.getClosestSupportAgent(typeInfo);
        if (supportedTypeInfo == null) {
            return BAJA_UI_LEX.getText("validateMedia.unsupportedType", cx, new Object[]{typeInfo});
        }
        NProperty[] supportedProps = ((ComplexType)supportedTypeInfo.getTypeSpec().getResolvedType()).getFrozenProperties();
        NProperty[] allProps = ((ComplexType)typeInfo.getTypeSpec().getResolvedType()).getFrozenProperties();
        if (allProps.length > supportedProps.length) {
            StringBuilder b = new StringBuilder();
            for (int i = supportedProps.length; i < allProps.length; ++i) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(allProps[i].getName());
            }
            return LEX.getText("validateMedia.onlySubclassSupportedMissingProperties", cx, new Object[]{typeInfo, b.toString()});
        }
        return LEX.getText("validateMedia.onlySubclassSupported", cx, new Object[]{typeInfo});
    }

    public static TypeInfo getClosestSupportAgent(TypeInfo typeInfo) {
        while (!typeInfo.equals(BWidget.TYPE.getTypeInfo()) && !typeInfo.equals(BBinding.TYPE.getTypeInfo())) {
            AgentList specificList = Sys.getRegistry().getSpecificAgents(typeInfo).filter((AgentFilter)new PxUxAgentFilter(typeInfo));
            if (specificList.size() > 0) {
                return typeInfo;
            }
            typeInfo = typeInfo.getSuperType();
        }
        return null;
    }

    public static boolean isChildWidgetValidationRequired(BComponent widget, BComponent childWidget, Context cx) {
        BIJavaScript js;
        TypeInfo typeInfo = widget.getType().getTypeInfo();
        AgentList list = PxUxAgentFilter.getAgentList(typeInfo).filter((AgentFilter)new PxUxAgentFilter(typeInfo));
        if (list.size() > 0 && (js = (BIJavaScript)list.getDefault().getInstance()) instanceof BIJavaScriptWidget) {
            BIJavaScriptWidget jsWidget = (BIJavaScriptWidget)js;
            return jsWidget.isChildWidgetValidationRequired(widget, childWidget, cx);
        }
        return true;
    }

    public static boolean isBindingValidationRequired(BComponent widget, BComponent binding, Context cx) {
        BIJavaScript js;
        TypeInfo typeInfo = widget.getType().getTypeInfo();
        AgentList list = PxUxAgentFilter.getAgentList(typeInfo).filter((AgentFilter)new PxUxAgentFilter(typeInfo));
        if (list.size() > 0 && (js = (BIJavaScript)list.getDefault().getInstance()) instanceof BIJavaScriptWidget) {
            BIJavaScriptWidget jsWidget = (BIJavaScriptWidget)js;
            return jsWidget.isBindingValidationRequired(binding, binding, cx);
        }
        return true;
    }
}

