/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.uxBuilder.ui;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.util.MediaUtil;
import com.tridium.util.PxUtil;
import com.tridium.web.WebUtil;
import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.OrdUtil;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BLayerStatus;
import javax.baja.ui.px.BLayerTag;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualGateway;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class UxMediaUtil {
    private static final List<String> IGNORED_VIEW_QUERY_PARAMS = Collections.singletonList("ux");
    private static final String CLASS_NAME = UxMediaUtil.class.getName();
    private static final Logger LOG = Logger.getLogger("niagara.uxMediaUtil");
    private static final TypeInfo SUBSTITUTE_PX_VIEW = PxUtil.typeInfo((String)"niagaraDriver:AbstractSubstitutePxView");
    private static final TypeInfo VIRTUAL_GATEWAY = BVirtualGateway.TYPE.getTypeInfo();
    private static final String CONTENT = "content";
    private static final String LAYERS = "layers";
    private static final String PROPS = "props";
    private static final String PRESERVE_IDENTITIES = "preserveIdentities";
    private static final String TYPE_SPEC = "t";
    private static final String KIDS = "k";
    private static final String PROPERTIES = "p";
    private static final String VALUE = "v";
    private static final String NAME = "n";
    private static final String HANDLE = "h";
    private static final String FLAGS = "f";
    private static final String FACETS = "ft";
    private static final String TARGETS = "ta";
    private static final String ORD = "o";
    private static final String BINDINGS = "bnd";
    private static final String LAYER_TAG = "LayerTag";
    private static BOrd baseOrd;

    private UxMediaUtil() {
    }

    public static synchronized void getMediaInfo(OrdTarget target, HttpServletRequest req, HttpServletResponse response, Context cx) throws Exception {
        PrintWriter writer = response.getWriter();
        JSONWriter jsonWriter = QuickJSONWriter.make((Appendable)writer);
        jsonWriter.object();
        boolean auditionMode = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"auditionMode", Boolean::parseBoolean, (Object)false);
        boolean next = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"next", Boolean::parseBoolean, (Object)false);
        boolean showValidationWarnings = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"showValidationWarnings", Boolean::parseBoolean, (Object)false);
        boolean auditionModeRemove = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"auditionModeRemove", Boolean::parseBoolean, (Object)false);
        boolean applyIncrement = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"applyIncrement", Boolean::parseBoolean, (Object)false);
        if (auditionModeRemove) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Removing Audition Mode cache");
            }
            req.getSession().removeAttribute(CLASS_NAME);
        }
        if (auditionMode) {
            BAbstractPxView abstractPxView;
            ViewQuery viewQuery;
            List<String> list = UxMediaUtil.getList(req, cx);
            BOrd ord = target.get() instanceof BPxFile ? target.getOrdWithoutViewQuery() : ((viewQuery = target.getViewQuery()) == null || viewQuery.getViewId() == null ? ((abstractPxView = MediaUtil.getAbstractPxView((OrdTarget)target, (Context)cx)) != null ? BOrd.make((BOrd)target.getOrdWithoutViewQuery(), (String)("view:" + abstractPxView.getAgentId())) : target.getOrdWithoutViewQuery()) : BOrd.make((BOrd)target.getOrdWithoutViewQuery(), (String)("view:" + viewQuery.getViewId())));
            int nextIndex = -1;
            int index = list.indexOf(ord.toString());
            nextIndex = applyIncrement ? UxMediaUtil.getNextResolvableIndex(list, index, next, cx) : UxMediaUtil.tryResolve(list, index, true, cx);
            if (nextIndex < list.size() && nextIndex > -1) {
                String nextOrd = list.get(nextIndex);
                jsonWriter.key("nextOrd").value((Object)nextOrd);
            }
            jsonWriter.key("auditionIndex").value((long)nextIndex);
            jsonWriter.key("auditionSize").value((long)list.size());
        }
        BTypeSpec mediaTypeSpec = MediaUtil.getMedia((OrdTarget)target, (Context)cx);
        if (showValidationWarnings) {
            BTypeSpec validateTypeSpec = BTypeSpec.make((String)((String)WebUtil.getParameter((ServletRequest)req, (String)"mediaType", SlotPath::unescape, (Object)mediaTypeSpec.toString())));
            jsonWriter.key("validationWarnings").value((Object)MediaUtil.getValidationWarnings((BTypeSpec)validateTypeSpec, (OrdTarget)target, (Context)cx));
        }
        jsonWriter.key("mediaType").value((Object)String.valueOf(MediaUtil.getMedia((OrdTarget)target, (Context)cx)));
        jsonWriter.key("isPxFile").value(target.get() instanceof BPxFile);
        jsonWriter.endObject();
    }

    private static List<String> getList(HttpServletRequest req, Context cx) throws Exception {
        List<String> list;
        Object o = req.getSession().getAttribute(CLASS_NAME);
        if (o instanceof List) {
            list = (List<String>)o;
        } else {
            list = UxMediaUtil.populateOrds(cx);
            req.getSession().setAttribute(CLASS_NAME, list);
        }
        return list;
    }

    private static int getNextResolvableIndex(List<String> list, int index, boolean next, Context cx) {
        int nextIndex = index + (next ? 1 : -1);
        if (nextIndex < 0) {
            nextIndex = list.size() - 1;
        } else if (nextIndex >= list.size()) {
            nextIndex = 0;
        }
        if (nextIndex < list.size() && nextIndex > -1) {
            return UxMediaUtil.tryResolve(list, nextIndex, next, cx);
        }
        return -1;
    }

    private static int tryResolve(List<String> list, int nextIndex, boolean next, Context cx) {
        if (nextIndex == -1) {
            return -1;
        }
        String nextOrd = list.get(nextIndex);
        try {
            BAbstractPxView pxView;
            OrdTarget target = BOrd.make((String)nextOrd).resolve(null, cx);
            if (target.get() instanceof BComponent && (pxView = MediaUtil.getAbstractPxView((OrdTarget)target, (Context)cx)) == null) {
                throw new Exception("View is missing:" + pxView);
            }
            return nextIndex;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "removing " + nextIndex + ": " + list.get(nextIndex), e);
            }
            list.remove(nextIndex);
            return UxMediaUtil.getNextResolvableIndex(list, nextIndex, next, cx);
        }
    }

    public static synchronized void setMediaInfo(OrdTarget target, HttpServletRequest req, HttpServletResponse response, Context cx) throws Exception {
        int auditionIndex;
        List<String> list;
        int nextIndex;
        String mediaType = (String)WebUtil.getParameter((ServletRequest)req, (String)"mediaType", SlotPath::unescape, null);
        boolean auditionMode = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"auditionMode", Boolean::parseBoolean, (Object)false);
        boolean preserveIdentities = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)PRESERVE_IDENTITIES, Boolean::parseBoolean, (Object)false);
        PrintWriter writer = response.getWriter();
        if (mediaType != null) {
            try {
                MediaUtil.setMedia((OrdTarget)target, (String)mediaType, (boolean)preserveIdentities, (Context)cx);
            }
            catch (Exception e) {
                throw new LocalizableException("uxBuilder", "servlet.cannotChangeMedia", new Object[]{UxMediaUtil.getNiceMessage(e, cx)}, (Throwable)e);
            }
        }
        String nextOrd = UxMediaUtil.getNextOrd(target);
        if (auditionMode && (nextIndex = UxMediaUtil.tryResolve(list = UxMediaUtil.getList(req, cx), auditionIndex = ((Integer)WebUtil.getParameter((ServletRequest)req, (String)"auditionIndex", Integer::parseInt, (Object)-1)).intValue(), true, cx)) < list.size() && nextIndex > -1) {
            nextOrd = list.get(auditionIndex);
        }
        JSONWriter jsonWriter = QuickJSONWriter.make((Appendable)writer);
        jsonWriter.object();
        jsonWriter.key("nextOrd").value((Object)nextOrd);
        jsonWriter.endObject();
    }

    public static synchronized void savePxFile(OrdTarget target, HttpServletRequest req, Context cx) throws Exception {
        String line;
        baseOrd = target.getOrd();
        BObject objTarget = target.get();
        if (objTarget instanceof BComponent) {
            BComponent comp = (BComponent)objTarget;
            String viewId = target.getViewQuery().getViewId();
            BPxView view = (BPxView)comp.get(viewId);
            objTarget = view.getPxFile().resolve(null, cx).get();
        }
        BIFile pxFile = (BIFile)objTarget;
        BFileSystem.INSTANCE.checkWritePermission(pxFile.getFilePath(), cx);
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = req.getReader();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        JSONObject jsonStructure = new JSONObject(buffer.toString());
        BWidget widget = (BWidget)UxMediaUtil.decodeWidgetFromJson(jsonStructure.getJSONObject(CONTENT), cx);
        PxLayer[] layers = UxMediaUtil.decodeLayersFromJson(jsonStructure);
        PxProperty[] properties = UxMediaUtil.decodeProperties(jsonStructure, cx);
        try (OutputStream out = pxFile.getOutputStream();){
            PxEncoder encoder = new PxEncoder(out);
            boolean preserveIdentities = properties.length > 0 || UxMediaUtil.getPreserveIdentities(jsonStructure);
            encoder.setPreserveIdentities(preserveIdentities);
            BTypeSpec media = BTypeSpec.make((String)"uxBuilder:UxMedia");
            encoder.encodeDocumentWithMedia(widget, properties, layers, media);
        }
    }

    private static boolean getPreserveIdentities(JSONObject jsonObject) {
        if (jsonObject.has(PRESERVE_IDENTITIES)) {
            return jsonObject.getBoolean(PRESERVE_IDENTITIES);
        }
        return false;
    }

    private static PxLayer[] decodeLayersFromJson(JSONObject jsonStructure) {
        if (jsonStructure.has(LAYERS)) {
            JSONArray jsonLayers = jsonStructure.getJSONArray(LAYERS);
            PxLayer[] layers = new PxLayer[jsonLayers.length()];
            for (int i = 0; i < jsonLayers.length(); ++i) {
                JSONObject jsonLayer = jsonLayers.getJSONObject(i);
                String name = jsonLayer.getString(NAME);
                BLayerStatus status = BLayerStatus.make((String)jsonLayer.getString("status"));
                layers[i] = new PxLayer(name, status);
            }
            return layers;
        }
        return new PxLayer[0];
    }

    private static PxProperty[] decodeProperties(JSONObject jsonStructure, Context cx) throws Exception {
        if (jsonStructure.has(PROPS)) {
            JSONArray jsonProperties = jsonStructure.getJSONArray(PROPS);
            PxProperty[] properties = new PxProperty[jsonProperties.length()];
            for (int i = 0; i < jsonProperties.length(); ++i) {
                JSONObject jsonProperty = jsonProperties.getJSONObject(i);
                String name = jsonProperty.getString(NAME);
                BTypeSpec type = BTypeSpec.make((String)jsonProperty.getString(TYPE_SPEC));
                BValue value = UxMediaUtil.decodeValue(jsonProperty.getJSONObject(VALUE), cx);
                SlotPath[] targets = new SlotPath[]{};
                if (jsonProperty.has(TARGETS)) {
                    JSONArray jsonTargets = jsonProperty.getJSONArray(TARGETS);
                    targets = new SlotPath[jsonTargets.length()];
                    for (int j = 0; j < jsonTargets.length(); ++j) {
                        String path = jsonTargets.getJSONObject(j).getString(ORD);
                        targets[j] = new SlotPath(path.substring("slot:".length()));
                    }
                }
                properties[i] = new PxProperty(name, type, value, targets);
            }
            return properties;
        }
        return new PxProperty[0];
    }

    private static BValue decodeWidgetFromJson(JSONObject jsonStructure, Context cx) throws Exception {
        String typeSpec = jsonStructure.getString(TYPE_SPEC);
        TypeInfo type = Sys.getRegistry().getType(typeSpec);
        BValue value = (BValue)type.getInstance();
        if (value instanceof BSimple) {
            value = UxMediaUtil.decodeValue(jsonStructure.getJSONObject(VALUE), cx);
        } else {
            UxMediaUtil.decodePropsAndKids(jsonStructure, (BComplex)value, cx);
        }
        return value;
    }

    private static BValue decodeValue(JSONObject value, Context cx) throws Exception {
        return UxMediaUtil.decodeValue(value, null, cx);
    }

    private static BValue decodeValue(JSONObject value, Type expectedType, Context cx) throws Exception {
        BValue val = BsonDecoderPlugin.unmarshal((JSONObject)value, (Context)cx);
        if (expectedType != null) {
            if (val instanceof BNumber) {
                val = BNumber.cast((double)((BNumber)val).getDouble(), (Type)expectedType);
            } else if (expectedType.is(BSimple.TYPE) && !expectedType.is(BString.TYPE) && val instanceof BString) {
                val = (BValue)BTypeSpec.make((Type)expectedType).getResolvedType().getInstance().asSimple().decodeFromString(val.toString());
            }
        }
        val.fw(205, (Object)baseOrd, (Object)cx, null, null);
        return val;
    }

    private static void decodePropsAndKids(JSONObject jsonStructure, BComplex complex, Context cx) throws Exception {
        String flags;
        Property prop;
        String name;
        int i;
        Pattern numeric = Pattern.compile("-?\\d+(\\.\\d+)?");
        JSONArray properties = jsonStructure.getJSONArray(PROPERTIES);
        JSONArray kids = jsonStructure.getJSONArray(KIDS);
        String type = complex.getType().getTypeName();
        for (i = 0; i < properties.length(); ++i) {
            JSONObject property = properties.getJSONObject(i);
            name = property.getString(NAME);
            JSONObject value = property.getJSONObject(VALUE);
            try {
                BValue propValue;
                prop = complex.getProperty(name);
                if (prop == null) {
                    if (name.equals(HANDLE) && complex.isComponent()) {
                        ((ComponentSlotMap)complex.fw(1)).setHandle((Object)value);
                    } else if (name.equals(LAYER_TAG) && complex.isComponent()) {
                        propValue = (BLayerTag)UxMediaUtil.decodeValue(value, cx);
                        complex.asComponent().add(LAYER_TAG, propValue);
                    } else {
                        propValue = UxMediaUtil.decodeValue(value, cx);
                        prop = complex.asComponent().add(name, propValue);
                    }
                } else {
                    propValue = complex.get(prop);
                    propValue = UxMediaUtil.decodeValue(value, prop.getType(), cx);
                    if (!propValue.isSimple()) {
                        throw new LocalizableException("uxBuilder", "servlet.expectingSimpleType");
                    }
                    complex.set(prop, propValue);
                }
                String string = flags = property.has(FLAGS) ? property.getString(FLAGS) : null;
                if (flags == null) continue;
                complex.setFlags((Slot)prop, Flags.decodeFromString((String)flags));
                continue;
            }
            catch (Exception e) {
                throw new LocalizableException("uxBuilder", "servlet.cannotDecode", new Object[]{type, name, UxMediaUtil.getNiceMessage(e, cx)}, (Throwable)e);
            }
        }
        for (i = 0; i < kids.length(); ++i) {
            JSONObject kid = kids.getJSONObject(i);
            name = kid.has(NAME) ? kid.getString(NAME) : null;
            name = name != null && numeric.matcher(name).matches() ? null : name;
            try {
                String facets;
                BValue kidWidget = UxMediaUtil.decodeWidgetFromJson(kid, cx);
                Property property = prop = name != null ? complex.getProperty(name) : null;
                if (prop != null) {
                    complex.set(name, kidWidget);
                } else {
                    prop = complex.asComponent().add(name, kidWidget);
                }
                flags = kid.has(FLAGS) ? kid.getString(FLAGS) : null;
                String string = facets = kid.has(FACETS) ? kid.getString(FACETS) : null;
                if (flags != null) {
                    complex.setFlags((Slot)prop, Flags.decodeFromString((String)flags));
                }
                if (facets == null || facets.isEmpty()) continue;
                complex.setFacets((Slot)prop, (BFacets)BFacets.DEFAULT.decodeFromString(facets));
                continue;
            }
            catch (Exception e) {
                throw new LocalizableException("uxBuilder", "servlet.cannotDecodeKid", new Object[]{type, kid.getString(NAME), UxMediaUtil.getNiceMessage(e, cx)}, (Throwable)e);
            }
        }
        if (jsonStructure.has(BINDINGS)) {
            JSONArray bindings = jsonStructure.getJSONArray(BINDINGS);
            for (int i2 = 0; i2 < bindings.length(); ++i2) {
                BValue binding = UxMediaUtil.decodeValue(bindings.getJSONObject(i2), cx);
                complex.asComponent().add(null, binding);
            }
        }
    }

    private static String getNiceMessage(Exception e, Context cx) {
        if (e instanceof LocalizableException) {
            return ((Localizable)e).toString(cx);
        }
        String message = e.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            return e.getClass().getName();
        }
        return message;
    }

    private static String getNextOrd(OrdTarget target) {
        return OrdUtil.getOrdWithoutViewQueryParameters((OrdTarget)target, IGNORED_VIEW_QUERY_PARAMS, (boolean)false).toString();
    }

    private static List<String> populateOrds(Context cx) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Generating new list");
        }
        if (Sys.getStation().getPermissions(cx).hasOperatorRead()) {
            UxMediaUtil.populate((BINavNode)Sys.getStation(), list, cx);
        }
        try {
            BIFile fileRoot = (BIFile)BOrd.make((String)"file:^").get();
            UxMediaUtil.populate((BINavNode)fileRoot, list, cx);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Problem with populating station files", e);
        }
        return list;
    }

    private static void populate(BINavNode root, List<String> list, Context cx) {
        BINavNode[] children;
        String navOrd;
        if (VIRTUAL_GATEWAY != null && root.getType().is(VIRTUAL_GATEWAY)) {
            return;
        }
        if (root instanceof BPxFile) {
            navOrd = String.valueOf(root.getNavOrd().relativizeToSession());
            UxMediaUtil.addToList(list, navOrd);
        } else if (root instanceof BIFile) {
            navOrd = String.valueOf(root.getNavOrd().relativizeToSession());
            if ("file:^nstations".equals(navOrd)) {
                return;
            }
        } else {
            root.asObject().getAgents(cx).forEach(agentInfo -> {
                if (agentInfo instanceof BAbstractPxView) {
                    BAbstractPxView abstractPxView = (BAbstractPxView)agentInfo;
                    Property property = abstractPxView.getPropertyInParent();
                    if (property != null && property.isFrozen()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            String message = "PxView is frozen:" + property.getName();
                            BComponent parentComponent = abstractPxView.getParentComponent();
                            if (parentComponent != null) {
                                message = "PxView is frozen:" + parentComponent.getSlotPath() + '/' + property.getName();
                            }
                            LOG.log(Level.FINE, message);
                        }
                        return;
                    }
                    if (abstractPxView instanceof BPxView) {
                        BPxView pxView = (BPxView)abstractPxView;
                        BOrd pxFileOrd = pxView.getPxFile();
                        try {
                            BObject file = pxFileOrd.get(null, cx);
                            if (!(file instanceof BPxFile)) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "PxView does not reference a PxFile:" + file);
                                }
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Problem resolving PxFile ord" + pxFileOrd, e);
                            }
                            return;
                        }
                        String navOrd = root.getNavOrd().relativizeToSession() + "|view:" + abstractPxView.getAgentId();
                        UxMediaUtil.addToList(list, navOrd);
                    } else if (SUBSTITUTE_PX_VIEW == null || !abstractPxView.getType().is(SUBSTITUTE_PX_VIEW)) {
                        UxMediaUtil.addToList(list, root.getNavOrd().relativizeToSession() + "|view:" + abstractPxView.getAgentId());
                    }
                }
            });
        }
        for (BINavNode child : children = root.getNavChildren()) {
            UxMediaUtil.populate(child, list, cx);
        }
    }

    private static void addToList(List<String> list, String ord) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, list.size() + ": " + ord);
        }
        list.add(ord);
    }
}

