/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.seriestransform.graph;

import com.tridium.history.BHistory;
import com.tridium.seriestransform.SeriesColumn;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySchema;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.exceptions.SchemaException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BSeriesSchema
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSeriesSchema.class);
    public static final String PRIMARY_KEY = "primaryKeyField";
    private static final Lexicon lex = Lexicon.make(BSeriesSchema.class);
    private static final String ERR_DUPLICATE_KEY = "fault.msg.schema.duplicatePrimaryKey";
    private static final String ERR_INVALID_SCHEMA_VALUE = "fault.msg.schema.invalidfieldvalue";
    private static final String ERR_INVALID_SCHEMA_SRC = "fault.msg.schema.invalidschemasrc";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTypeSpec getFieldType(String fieldName) {
        BValue value;
        if (null != fieldName && (value = this.get(fieldName)) instanceof BTypeSpec) {
            return (BTypeSpec)value;
        }
        return null;
    }

    public BFacets getFieldFacets(String fieldName) {
        BFacets slotFacets;
        if (null != fieldName && null != this.getSlot(fieldName) && null != (slotFacets = this.getSlotFacets(this.getSlot(fieldName)))) {
            return slotFacets;
        }
        return null;
    }

    public String[] getFieldNames() {
        this.lease(1);
        List<String> fields = Arrays.stream(this.getDynamicPropertiesArray()).map(Slot::getName).collect(Collectors.toList());
        return fields.toArray(new String[0]);
    }

    public String getKeyField() {
        String[] fieldNames;
        for (String field : fieldNames = this.getFieldNames()) {
            BFacets fieldFacets = this.getFieldFacets(field);
            if (null == fieldFacets.get(PRIMARY_KEY) || !fieldFacets.getb(PRIMARY_KEY, false)) continue;
            return field;
        }
        return SeriesColumn.COL_TIMESTAMP;
    }

    public void mergeFieldFacets(String fieldName, BFacets mergeFacets) {
        if (null == fieldName || null == mergeFacets) {
            return;
        }
        Slot slot = this.getSlot(fieldName);
        if (null != slot) {
            BFacets slotFacets = slot.getFacets();
            BFacets newFacets = BFacets.make((BFacets)slotFacets, (BFacets)mergeFacets);
            this.setFacets(slot, newFacets);
        }
    }

    public boolean addField(String fieldName, BTypeSpec fieldType, BFacets fieldFacets) {
        if (null != fieldName && null == this.get(fieldName) && null != fieldType) {
            Property propAdded;
            if (!SlotPath.isValidName((String)fieldName)) {
                return false;
            }
            if (null == fieldFacets) {
                fieldFacets = BFacets.NULL;
            }
            return null != (propAdded = this.add(fieldName, (BValue)fieldType, 0, fieldFacets, null));
        }
        return false;
    }

    public void removeField(String fieldName) {
        if (null != fieldName && null != this.get(fieldName)) {
            this.remove(fieldName);
        }
    }

    public boolean hasField(String fieldName) {
        return null != fieldName && null != this.get(fieldName);
    }

    public void loadSchema(BObject src) throws SchemaException {
        if (null != src) {
            this.removeAll();
            if (src instanceof BHistory) {
                this.processHistorySchema((BHistory)src);
            } else if (src instanceof BITable) {
                try {
                    BITable table = (BITable)src;
                    this.processTableSchema((BITable<BComplex>)table);
                }
                catch (ClassCastException e) {
                    throw new SchemaException(lex.getText(ERR_INVALID_SCHEMA_SRC, new Object[]{src.toString()}), e);
                }
            } else {
                throw new SchemaException(lex.getText(ERR_INVALID_SCHEMA_SRC, new Object[]{src.toString()}));
            }
        }
    }

    private void processTableSchema(BITable<BComplex> srcData) {
        ColumnList columns = srcData.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            String colName = column.getName();
            Type columnType = column.getType();
            BFacets columnFacets = column.getFacets();
            int colFlags = column.getFlags();
            BTypeSpec typeSpec = columnType.getTypeSpec();
            this.add(colName, (BValue)typeSpec, colFlags, columnFacets, null);
        }
    }

    private void processHistorySchema(BHistory srcData) {
        BHistoryConfig config = srcData.getConfig();
        ColumnList columns = srcData.getColumns();
        BHistorySchema schema = config.getSchema();
        int count = schema.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Column column;
            String colName = schema.getColumnName(i);
            BTypeSpec columnType = schema.getColumnType(i);
            BFacets colFacets = BFacets.NULL;
            int colFlags = 0;
            if (null != columns && null != (column = columns.get(colName))) {
                colFacets = column.getFacets();
                colFlags = column.getFlags();
            }
            if (colName.equals(BHistoryRecord.timestamp.getName())) {
                colFacets = BFacets.make((BFacets)colFacets, (BFacets)BFacets.make((String)PRIMARY_KEY, (boolean)true));
            }
            this.add(colName, (BValue)columnType, colFlags, colFacets, null);
        }
    }

    public synchronized boolean equivalent(Object obj) {
        if (obj instanceof BSeriesSchema) {
            String[] srcFieldNames;
            BSeriesSchema arg = (BSeriesSchema)((Object)obj);
            String[] argFieldNames = arg.getFieldNames();
            if (argFieldNames.length != (srcFieldNames = this.getFieldNames()).length) {
                return false;
            }
            for (String argFieldName : argFieldNames) {
                BTypeSpec argType = arg.getFieldType(argFieldName);
                BTypeSpec srcType = this.getFieldType(argFieldName);
                if (null == srcType || null == argType) {
                    return false;
                }
                if (!argType.equals((Object)srcType)) {
                    return false;
                }
                BFacets argFieldFacets = arg.getFieldFacets(argFieldName);
                BFacets srcFacets = this.getFieldFacets(argFieldName);
                if (srcFacets.equals((Object)argFieldFacets)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(Context context) {
        return Arrays.stream(this.getDynamicPropertiesArray()).map(prop -> prop.getName() + '=' + this.get((Property)prop)).collect(Collectors.joining(","));
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!value.getType().is(BTypeSpec.TYPE)) {
            throw new BajaRuntimeException(lex.getText(ERR_INVALID_SCHEMA_VALUE, new Object[]{name}));
        }
    }

    public void added(Property property, Context context) {
        this.removeDuplicateKeyFacet(property);
    }

    public void changed(Property property, Context context) {
        this.removeDuplicateKeyFacet(property);
    }

    private void removeDuplicateKeyFacet(Property prop) {
        BFacets facets = this.getSlotFacets((Slot)prop);
        if (null != facets.get(PRIMARY_KEY)) {
            Property[] fields;
            for (Property field : fields = this.getDynamicPropertiesArray()) {
                BFacets fieldFacets;
                if (field == prop || null == (fieldFacets = field.getFacets()) || null == fieldFacets.get(PRIMARY_KEY)) continue;
                BGraphNode.log.warning(lex.getText(ERR_DUPLICATE_KEY, new Object[]{prop.getName()}));
                facets = BFacets.makeRemove((BFacets)facets, (String)PRIMARY_KEY);
                this.setFacets((Slot)prop, facets);
                return;
            }
        }
    }
}

