/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.source;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.BSeriesIntervalEnum;
import com.tridium.seriestransform.quantize.BNonQuantizedTable;
import com.tridium.seriestransform.quantize.BQuantizationTable;
import java.util.LinkedList;
import java.util.Optional;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dataSource", type="BFormat", defaultValue="BFormat.DEFAULT", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"seriesTransform:FormatOrdFE\")")}), @NiagaraProperty(name="dateRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="srcSchema", type="BSeriesSchema", defaultValue="new BSeriesSchema()"), @NiagaraProperty(name="quantInterval", type="BSeriesInterval", defaultValue="new BSeriesInterval()", flags=8)})
@NiagaraTopic(name="intervalModified", eventType="BSeriesInterval", flags=4)
public class BHistorySourceNode
extends BGraphNode {
    @Generated
    public static final Property dataSource = BHistorySourceNode.newProperty((int)8, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"seriesTransform:FormatOrdFE")));
    @Generated
    public static final Property dateRange = BHistorySourceNode.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property srcSchema = BHistorySourceNode.newProperty((int)0, (BValue)new BSeriesSchema(), null);
    @Generated
    public static final Property quantInterval = BHistorySourceNode.newProperty((int)8, (BValue)new BSeriesInterval(), null);
    @Generated
    public static final Topic intervalModified = BHistorySourceNode.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistorySourceNode.class);
    private static final Lexicon lex = Lexicon.make(BHistorySourceNode.class);
    private static final String INVALID_DATA_SRC = lex.getText("fault.msg.invalidHistorySource");
    private static final String INVALID_PERMISSIONS_KEY = "fault.msg.invalidPermissions";

    @Generated
    public BFormat getDataSource() {
        return (BFormat)this.get(dataSource);
    }

    @Generated
    public void setDataSource(BFormat v) {
        this.set(dataSource, (BValue)v, null);
    }

    @Generated
    public BDynamicTimeRange getDateRange() {
        return (BDynamicTimeRange)this.get(dateRange);
    }

    @Generated
    public void setDateRange(BDynamicTimeRange v) {
        this.set(dateRange, (BValue)v, null);
    }

    @Generated
    public BSeriesSchema getSrcSchema() {
        return (BSeriesSchema)this.get(srcSchema);
    }

    @Generated
    public void setSrcSchema(BSeriesSchema v) {
        this.set(srcSchema, (BValue)v, null);
    }

    @Generated
    public BSeriesInterval getQuantInterval() {
        return (BSeriesInterval)this.get(quantInterval);
    }

    @Generated
    public void setQuantInterval(BSeriesInterval v) {
        this.set(quantInterval, (BValue)v, null);
    }

    @Generated
    public void fireIntervalModified(BSeriesInterval event) {
        this.fire(intervalModified, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams args, BOrd base, Context cx) throws TransformException {
        if (inputs.length > 0) {
            return inputs;
        }
        BOrd schemaOrd = BOrd.NULL;
        BFormat relativeSource = (BFormat)args.get(dataSource.getName(), (BValue)this.getDataSource());
        BDynamicTimeRange range = (BDynamicTimeRange)args.get(dateRange.getName(), (BValue)this.getDateRange());
        String historyOrdParams = BHistorySourceNode.getHistoryOrdParams(range);
        String formatStr = relativeSource.getFormat();
        if (null != formatStr && !formatStr.isEmpty()) {
            BObject object = base.get();
            String format = relativeSource.format((Object)object);
            if (format.contains("?") && historyOrdParams.length() > 0) {
                historyOrdParams = historyOrdParams.replace('?', ';');
            }
            try {
                schemaOrd = BOrd.make((String)(format + historyOrdParams));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        LinkedList<BSeriesTransformTable> results = new LinkedList<BSeriesTransformTable>();
        if (schemaOrd != BOrd.DEFAULT) {
            OrdQuery[] queries;
            for (OrdQuery query : queries = schemaOrd.parse()) {
                BPermissions permissions;
                BIHistory history;
                if (!(query instanceof HistoryQuery)) continue;
                HistoryQuery historyQuery = (HistoryQuery)query;
                BHistoryId historyId = historyQuery.getHistoryId();
                if (historyId == null) {
                    throw new SourceException(INVALID_DATA_SRC);
                }
                BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                try (HistorySpaceConnection conn = localDb.getConnection(null);){
                    history = conn.getHistory(historyId);
                }
                if (null != cx && null != cx.getUser() && !(permissions = cx.getUser().getPermissionsFor((BIProtected)history)).hasOperatorRead()) {
                    String text = lex.getText(INVALID_PERMISSIONS_KEY, new Object[]{historyQuery.toString()});
                    throw new SourceException(text);
                }
                BSeriesSchema schema = this.getSrcSchema();
                Optional.ofNullable(schema.getProperty("timestamp")).ifPresent(prop -> {
                    BTimeZone timezone = history.getConfig().getTimeZone();
                    schema.setFacets((Slot)prop, BFacets.make((BFacets)prop.getFacets(), (BFacets)BFacets.make((String)"TimeZone", (BIDataValue)timezone)));
                });
                Optional.ofNullable(schema.getProperty("value")).ifPresent(prop -> {
                    if (history instanceof BHistory) {
                        ColumnList cols = ((BHistory)history).getColumns();
                        Optional.ofNullable(cols.get("value")).ifPresent(col -> {
                            BFacets colFacets = col.getFacets();
                            schema.setFacets((Slot)prop, BFacets.make((BFacets)prop.getFacets(), (BFacets)colFacets));
                        });
                    }
                });
            }
            BObject object = schemaOrd.get(base.get());
            if (object instanceof BITable) {
                try {
                    BITable table = (BITable)object;
                    this.setStatus(BStatus.ok);
                    BSeriesInterval interval = this.getQuantInterval();
                    if (interval.getDesc() == BSeriesIntervalEnum.none) {
                        results.add(new BNonQuantizedTable(this.getName(), this.getSchema(), (BITable<BComplex>)table));
                    } else {
                        results.add(new BQuantizationTable(this.getName(), this.getSchema(), interval, (BITable<BComplex>)table));
                    }
                    return results.toArray(new BSeriesTransformTable[0]);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        throw new SourceException(INVALID_DATA_SRC);
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema = this.getSrcSchema();
        return schema;
    }

    @Override
    public void doCheckSchema() throws ConfigException {
    }

    private static String getHistoryOrdParams(BDynamicTimeRange range) {
        if (range == BDynamicTimeRange.DEFAULT) {
            return "";
        }
        BAbsTime currentTime = BAbsTime.now();
        BAbsTime startTime = range.getStartTime(currentTime);
        BAbsTime endTime = range.getEndTime(currentTime);
        String query = "?start=" + startTime.encodeToString() + ';';
        query = query + "end=" + endTime.encodeToString() + ';';
        return query;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && context != Context.decoding && property == srcSchema) {
            this.fireSchemaModified(this.getSchema());
        }
        if (this.isRunning() && property == quantInterval) {
            this.fireIntervalModified(this.getQuantInterval());
        }
        super.changed(property, context);
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("source.icon");
        BOrdList ordList = BOrdList.make((String)iconsrc);
        return BIcon.make((BOrdList)ordList);
    }
}

