/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.scale;

import com.tridium.seriestransform.IntervalSeriesCursor;
import java.util.Map;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.nre.util.IFilter;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;

public class ScaleCursor
extends IntervalSeriesCursor<BComplex> {
    private final Map<String, Double> scaleFactors;
    private final Cursor<BComplex> innerCursor;
    private BComplex currentRecord;
    private final IFilter filter;
    private final String[] fieldNames;

    public ScaleCursor(BSeriesSchema schema, BITable<BComplex> table, Map<String, Double> scaling, IFilter filter) {
        super(table);
        this.fieldNames = schema.getFieldNames();
        this.scaleFactors = scaling;
        this.innerCursor = table.cursor();
        this.filter = filter;
    }

    public Row<BComplex> row() {
        return new SeriesTransformRow<BComplex>(this.getTable(), this.currentRecord);
    }

    public boolean advanceCursor() {
        if (this.innerCursor.next()) {
            this.currentRecord = (BComplex)this.innerCursor.get();
            if (null != this.filter && !this.filter.accept((Object)this.currentRecord)) {
                return this.next();
            }
            for (String fieldName : this.fieldNames) {
                BValue value = this.currentRecord.get(fieldName);
                BValue scaledValue = this.scaleValue(fieldName, value);
                this.currentRecord.set(fieldName, scaledValue);
            }
            return true;
        }
        return false;
    }

    protected void closeCursor() {
        this.innerCursor.close();
    }

    private BDouble getScaleFactor(String fieldName) {
        if (null != this.scaleFactors && this.scaleFactors.containsKey(fieldName)) {
            Double val = this.scaleFactors.get(fieldName);
            if (val instanceof Double) {
                Double scale = val;
                return BDouble.make((double)scale);
            }
            if (val instanceof BDouble) {
                return (BDouble)val;
            }
        }
        return null;
    }

    private BValue scaleValue(String fieldName, BValue cursorVal) {
        BDouble scale = this.getScaleFactor(fieldName);
        if (null != scale && cursorVal instanceof BNumber) {
            BNumber value = (BNumber)cursorVal;
            if (cursorVal instanceof BLong) {
                return BLong.make((long)(scale.getLong() * value.getLong()));
            }
            if (cursorVal instanceof BFloat) {
                return BFloat.make((float)(scale.getFloat() * value.getFloat()));
            }
            if (cursorVal instanceof BInteger) {
                return BInteger.make((int)(scale.getInt() * value.getInt()));
            }
            if (cursorVal instanceof BDouble) {
                return BDouble.make((double)(scale.getDouble() * value.getDouble()));
            }
        }
        return cursorVal;
    }
}

