/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridium.seriestransform.functions.BFunctionMapping;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;

public abstract class FunctionCursor<T extends BComplex>
extends IntervalSeriesCursor<T> {
    private static final String ERR_FIELD_NOT_FOUND = "functions.err.fieldNotFound";
    private static final String ERR_FUNCTION_FAILED = "functions.err.failed";
    protected BFunctionMapping[] functions;
    private final String keyField;

    public FunctionCursor(String keyField) {
        super(null);
        this.keyField = keyField;
    }

    protected String getKeyField() {
        return this.keyField;
    }

    protected void applySeriesFunction(Map<String, List<? extends BComplex>> series, BComplex resultRecord, boolean allowNonCumulative) throws TransformException {
        if (null == series || series.isEmpty()) {
            return;
        }
        Iterator<List<? extends BComplex>> seriesIt = series.values().iterator();
        List<? extends BComplex> records = seriesIt.next();
        Iterator<? extends BComplex> recordsIt = records.iterator();
        BComplex baseRecord = recordsIt.next();
        resultRecord.set(this.keyField, baseRecord.get(this.keyField));
        for (BFunctionMapping fm : this.functions) {
            BTypeSpec functionSpec = fm.getFunctionTypeSpec();
            BTransformFunction function = BTransformFunction.getFunction(functionSpec);
            String[] fieldNames = fm.getArgumentFields();
            String resultSlotName = fm.getOutputField();
            Property resultSlot = resultRecord.getProperty(resultSlotName);
            if (!function.isCumulative() && !allowNonCumulative) continue;
            if (null == resultSlot) {
                log.severe(lex.getText(ERR_FIELD_NOT_FOUND, new Object[]{resultSlotName}));
                log.severe(lex.getText(ERR_FUNCTION_FAILED, new Object[]{function.getFunctionName()}));
                continue;
            }
            function.applyFunction(series, fieldNames, resultSlot, resultRecord);
        }
    }
}

