/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.BITransformFunctionNode;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFunctionMap
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFunctionMap.class);
    private static final Lexicon lex = Lexicon.make(BFunctionMap.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BFunctionMapping) {
            BFunctionMapping mapping = (BFunctionMapping)value;
            BTypeSpec functionTypeSpec = mapping.getFunctionTypeSpec();
            BITransformFunctionNode parent = (BITransformFunctionNode)this.getParent();
            BTransformFunction function = BTransformFunction.getFunction(functionTypeSpec);
            if (null != parent && !parent.allowNonCumulative() && !function.isCumulative()) {
                String msg = lex.getText("functionNode.functionParentException", new Object[]{functionTypeSpec.getTypeName(), parent.getType().getTypeName()});
                throw new BajaRuntimeException(msg);
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BITransformFunctionNode;
    }

    public synchronized boolean equivalent(Object obj) {
        BFunctionMapping[] localMappings;
        BFunctionMap src;
        BFunctionMapping[] srcMappings;
        boolean isEquivalent = false;
        if (obj instanceof BFunctionMap && (srcMappings = (BFunctionMapping[])(src = (BFunctionMap)((Object)obj)).getChildren(BFunctionMapping.class)).length == (localMappings = (BFunctionMapping[])this.getChildren(BFunctionMapping.class)).length) {
            Set<String> lclKeys;
            Map<String, BFunctionMapping> srcMap = Arrays.stream(srcMappings).collect(Collectors.toMap(BFunctionMapping::getOutputField, map -> map));
            Map<String, BFunctionMapping> lclMap = Arrays.stream(localMappings).collect(Collectors.toMap(BFunctionMapping::getOutputField, map -> map));
            Set<String> srcKeys = srcMap.keySet();
            if (srcKeys.equals(lclKeys = lclMap.keySet())) {
                isEquivalent = true;
                for (Map.Entry<String, BFunctionMapping> entry : srcMap.entrySet()) {
                    BFunctionMapping lclMapping;
                    BFunctionMapping srcMapping = entry.getValue();
                    if (srcMapping.equivalent((Object)(lclMapping = lclMap.get(entry.getKey())))) continue;
                    isEquivalent = false;
                    break;
                }
            }
        }
        return isEquivalent;
    }
}

