/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import com.tridium.seriestransform.functions.BSumSeries;
import java.util.List;
import java.util.Map;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFindAverage
extends BSumSeries {
    @Generated
    public static final Type TYPE = Sys.loadType(BFindAverage.class);
    protected static final Lexicon lex = Lexicon.make(BTransformFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.findAverage");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.findAverage");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    @Override
    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property dstSlot, BComplex resultRecord) throws TransformException {
        BDouble sum = null;
        BUnit dstUnits = BFindAverage.getUnits(dstSlot);
        int size = 0;
        for (String name : srcProps) {
            List<? extends BComplex> records = this.getSeriesRecords(series, BFindAverage.getSeriesName(name));
            for (BComplex bComplex : records) {
                Property srcProp = bComplex.getProperty(BFindAverage.getFieldName(name));
                try {
                    BNumber check = this.sumValues((BNumber)sum, bComplex, srcProp, dstUnits);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    sum = check;
                    ++size;
                }
                catch (SourceException e) {
                    sum = BDouble.NaN;
                }
            }
        }
        BDouble avg = BDouble.NaN;
        if (size != 0) {
            avg = this.divideValues((BNumber)sum, (BNumber)BInteger.make((int)size));
        }
        BFindAverage.setRecordValue(resultRecord, dstSlot, (BValue)avg);
    }

    protected BNumber divideValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() / b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() / b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() / b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() / b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() / b.getDouble()));
    }
}

