/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.cleanser.replacers;

import com.tridium.seriestransform.cleanser.interfaces.BIDetector;
import com.tridium.seriestransform.cleanser.interfaces.BIValueReplacer;
import com.tridium.seriestransform.cleanser.replacers.BReplaceWithLastGood;
import com.tridium.seriestransform.cleanser.replacers.BReplaceWithNextGood;
import javax.baja.collection.BITable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BReplaceWithInterpolation
extends BObject
implements BIValueReplacer {
    @Generated
    public static final Type TYPE = Sys.loadType(BReplaceWithInterpolation.class);
    BReplaceWithNextGood nextGood;
    BReplaceWithLastGood lastGood;

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public BValue supplyReplacement(BValue data) {
        BDouble theNextGood = (BDouble)this.nextGood.supplyReplacement(data);
        BDouble theLastGood = (BDouble)this.lastGood.supplyReplacement(data);
        if (!this.isZero((BValue)theNextGood) && !this.isZero((BValue)theLastGood)) {
            double average = (theLastGood.getDouble() + theNextGood.getDouble()) / 2.0;
            return BDouble.make((double)average);
        }
        if (this.isZero((BValue)theNextGood) && this.isZero((BValue)theLastGood)) {
            return BDouble.make((double)0.0);
        }
        if (!this.isZero((BValue)theLastGood)) {
            return theLastGood;
        }
        return theNextGood;
    }

    boolean isZero(BValue val) {
        return val.equivalent((Object)BDouble.make((double)0.0));
    }

    @Override
    public void examineEntry(BValue entry) {
        this.nextGood.examineEntry(entry);
        this.lastGood.examineEntry(entry);
    }

    @Override
    public void initialize(BITable<? extends BComplex> table, BIDetector chosenDetector) {
        this.lastGood = new BReplaceWithLastGood();
        this.lastGood.initialize(table, chosenDetector);
        this.nextGood = new BReplaceWithNextGood();
        this.nextGood.initialize(table, chosenDetector);
    }
}

