/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform;

import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.nre.util.IFilter;
import javax.baja.registry.TypeInfo;
import javax.baja.seriestransform.SeriesCursor;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public abstract class IntervalSeriesCursor<T extends BComplex>
extends SeriesCursor<T> {
    public static final Logger log = Logger.getLogger("seriesTransform.cursors");
    protected static final Lexicon lex = Lexicon.make(IntervalSeriesCursor.class);
    protected static final BRelTime THIRTY_MIN = BRelTime.makeMinutes((int)30);
    protected static final BRelTime FIFTEEN_MIN = BRelTime.makeMinutes((int)15);
    protected static final BRelTime FIVE_MIN = BRelTime.makeMinutes((int)5);
    protected IFilter filter;
    protected BAbsTime intervalStartTime;
    protected BAbsTime intervalEndTime;
    protected boolean intervalDefined;

    protected IntervalSeriesCursor(BITable<T> series) {
        super(series);
    }

    protected void initTimes(BITable<T> timeSeries) {
        BFacets tableFacets = timeSeries.getTableFacets();
        BTimeZone timezone = (BTimeZone)tableFacets.get("TimeZone", null);
        if (timezone != null) {
            if (this.intervalStartTime != null) {
                this.intervalStartTime = BAbsTime.make((long)this.intervalStartTime.getMillis(), (BTimeZone)timezone);
            }
            if (this.intervalEndTime != null) {
                this.intervalEndTime = BAbsTime.make((long)this.intervalEndTime.getMillis(), (BTimeZone)timezone);
            }
        }
    }

    protected static BValue getDefaultValue(Type valueType) {
        return IntervalSeriesCursor.getDefaultValue(valueType, null);
    }

    protected static BValue getDefaultValue(Type valueType, BValue currentValue) {
        TypeInfo[] concreteTypes;
        if (valueType.getTypeInfo().is(BNumber.TYPE)) {
            return BDouble.NaN;
        }
        if (currentValue != null && valueType.getTypeInfo().is(BBoolean.TYPE)) {
            return currentValue;
        }
        if (valueType.isAbstract() && (concreteTypes = Sys.getRegistry().getConcreteTypes(valueType.getTypeInfo())).length > 0) {
            valueType = concreteTypes[0].getTypeSpec().getResolvedType();
        }
        return valueType.getInstance().asValue();
    }

    public static BComponent createTemplateRecord(BSeriesSchema recordSchema) {
        String[] fieldNames;
        BComponent templateRecord = new BComponent();
        for (String fieldName : fieldNames = recordSchema.getFieldNames()) {
            BTypeSpec fieldType = recordSchema.getFieldType(fieldName);
            BFacets fieldFacets = recordSchema.getFieldFacets(fieldName);
            BValue defaultValue = IntervalSeriesCursor.getDefaultValue(fieldType.getResolvedType());
            templateRecord.add(fieldName, defaultValue, 0, fieldFacets, null);
        }
        return templateRecord;
    }

    protected static void clearRecord(BComplex record) {
        SlotCursor properties = record.getProperties();
        while (properties.next()) {
            Property slot = ((Property)properties.slot()).asProperty();
            BValue defaultValue = IntervalSeriesCursor.getDefaultValue(slot.getType(), properties.get().asValue());
            record.set(slot, defaultValue);
        }
    }

    protected static void copyRecord(BComplex srcRecord, BComponent dstRecord) {
        if (null == srcRecord || null == dstRecord) {
            return;
        }
        SlotCursor properties = srcRecord.getProperties();
        while (properties.next()) {
            Property slot = ((Property)properties.slot()).asProperty();
            BValue bValue = srcRecord.get(slot);
            String name = slot.getName();
            if (null != dstRecord.get(name)) {
                dstRecord.set(name, bValue);
                continue;
            }
            dstRecord.add(name, bValue, 0, slot.getFacets(), null);
        }
    }
}

